#!/bin/bash


if [ -e /tmp/usb_fastcheck ]; then
   if [ ! -e /tmp/usb_auth_enabled -a ! -e /tmp/usb_whitelist ]; then

       #ENABLED=$(sys_params -l factory/options/usb_auth/enabled)
       #ENABLED=$( grep -m 1 "^usb_auth/enabled=" "/mnt/factory/etc/EPAD/system.ini" | cut -d'=' -f2)
       ENABLED=$(iniread 'options\usb_auth\enabled' /mnt/factory/etc/EPAD/system.ini)
       [ "$ENABLED" == "true" ] && touch /tmp/usb_auth_enabled

       #WHITELIST=$(sys_params -l factory/system/usb_devices | tr ',' ' ' )
       #WHITELIST=$( grep -m 1 "^usb_devices=" "/mnt/factory/etc/EPAD/system.ini" | cut -d'=' -f2 | tr ',' ' ' )
       WHITELIST="$(iniread 'system\usb_devices' /mnt/factory/etc/EPAD/system.ini)"
       echo $WHITELIST > /tmp/usb_whitelist
   fi

   [ -e /tmp/usb_auth_enabled ] || exit 0

   SYSFS_PATH=$1
   PID=$2
   VID=$3

   [ -z $PID -o -z $VID ] && exit 0

   for dev in $(cat /tmp/usb_whitelist); do
      [ "${dev:0:4}" = "$VID" -a "${dev:5:4}" = "$PID" ] && exit 0
   done
else
   [ "$(iniread 'options\usb_auth\enabled' /mnt/factory/etc/EPAD/system.ini)" == "true" ] || exit 0

   SYSFS_PATH=$1
   PID=$2
   VID=$3

   [ -z $PID -o -z $VID ] && exit 0

   WHITELIST="$(iniread 'system\usb_devices' /mnt/factory/etc/EPAD/system.ini | tr ',' ' ' )"
   for dev in $WHITELIST; do 
      [ "${dev:0:4}" = "$VID" -a "${dev:5:4}" = "$PID" ] && exit 0
   done
fi

echo 1 > $SYSFS_PATH/remove 
